//+ Carlos R. L. Rodrigues
//@ http://jsfromhell.com/classes/gradient [rev. #0]

Gradient = function(i, e, t){
	var o = this;
	o.i = i, o.e = e, o.t = --t, o._ = 0, o.a = [];
	o.fix = function(v){return v.length < 2 ? "0" + v : v;}
	for(var x, j = 0; j < 3; j++)
		o.a[j] = [((e >> (j << 3) & 0xff) - (x = (i >> (j << 3) & 0xff))) / t, x];
};
Gradient.prototype.getColorAt = function(a){
	for(var o = this, a = a > o.t ? o.t : a < 0 ? 0 : a, s = "", i = 0; i < 3; i++)
		s = o.fix((o.a[i][1] + o.a[i][0] * a >> 0).toString(16)) + s;
	return s;
};
Gradient.prototype.next = function(){
	var o = this;
	return o.t >= o._ && o.getColorAt(o._++);
};
Gradient.prototype.reset = function(){
	this._ = 0;
};